/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.client.model.projectile;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.client.model.ModelCreatureObj;
import com.lycanitesmobs.client.renderer.RenderCreature;
import com.lycanitesmobs.client.renderer.layer.LayerCreatureBase;
import com.lycanitesmobs.client.renderer.layer.LayerCreatureEffect;
import javax.vecmath.Vector4f;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class LightBallModel
extends ModelCreatureObj {
    LayerCreatureEffect ballGlowLayer;

    public LightBallModel() {
        this(1.0f);
    }

    public LightBallModel(float shadowSize) {
        this.initModel("lightball", LycanitesMobs.modInfo, "projectile/lightball");
    }

    @Override
    public void addCustomLayers(RenderCreature renderer) {
        super.addCustomLayers(renderer);
        this.ballGlowLayer = new LayerCreatureEffect(renderer, "", true, LayerCreatureEffect.BLEND.ADD.id, true);
        renderer.func_177094_a(this.ballGlowLayer);
    }

    @Override
    public void animatePart(String partName, EntityLiving entity, float time, float distance, float loop, float lookY, float lookX, float scale) {
        super.animatePart(partName, entity, time, distance, loop, lookY, lookX, scale);
        this.rotate(loop * 8.0f, 0.0f, 0.0f);
    }

    @Override
    public boolean canRenderPart(String partName, Entity entity, LayerCreatureBase layer, boolean trophy) {
        if (partName.equals("ball02") || partName.equals("ball03")) {
            return layer == this.ballGlowLayer;
        }
        return layer == null;
    }

    @Override
    public Vector4f getPartColor(String partName, Entity entity, LayerCreatureBase layer, boolean trophy, float loop) {
        float glowSpeed = 40.0f;
        float glow = loop * glowSpeed % 360.0f;
        float color = (float)Math.cos(Math.toRadians(glow)) * 0.1f + 0.9f;
        return new Vector4f(color, color, color, 1.0f);
    }

    @Override
    public void onRenderStart(LayerCreatureBase layer, Entity entity, boolean renderAsTrophy) {
        super.onRenderStart(layer, entity, renderAsTrophy);
        int i = 0xF000F0;
        int j = i % 65536;
        int k = i / 65536;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)j, (float)k);
        GlStateManager.func_179140_f();
    }

    @Override
    public void onRenderFinish(LayerCreatureBase layer, Entity entity, boolean renderAsTrophy) {
        super.onRenderFinish(layer, entity, renderAsTrophy);
        int i = entity.func_70070_b();
        int j = i % 65536;
        int k = i / 65536;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)j, (float)k);
        GlStateManager.func_179145_e();
    }
}

